function pc_bar_chart($question, $answers) {

    // definiowanie kolorw supkw
    $colors = array(array(255,102,0), array(0,153,0),
                    array(51,51,204), array(255,0,51),
                    array(255,255,0), array(102,255,255), 
                    array(153,0,204));

    $total = array_sum($answers['votes']);
    
    // definiowanie odstpw i innych przydatnych wartoci
    $padding = 5;
    $line_width = 20;
    $scale = $line_width * 7.5;
    $bar_height = 10;

    $x = $y = $padding;

    // alokacja dosy duej iloci miejsca, poniewa nie wiemy
    // na ile w czasie rozronie si obraz
    $image = ImageCreate(150, 500);
    $bg_color = ImageColorAllocate($image, 224, 224, 224);
    $black = ImageColorAllocate($image, 0, 0, 0);

    // wywietlanie pytania
    $wrapped = explode("\n", wordwrap($question, $line_width));
    foreach ($wrapped as $line) {
        ImageString($image, 3, $x, $y , $line, $black);
        $y += 12;
    }

    $y += $padding;

    // wywietlanie odpowiedzi
    for ($i = 0; $i < count($answers['answer']); $i++) { 

        // format procentowy
        $percent = sprintf('%1.1f', 100*$answers['votes'][$i]/$total);
        $bar = sprintf('%d', $scale*$answers['votes'][$i]/$total);

        // pobranie kolorw
        $c = $i % count($colors); // obsuga przypadkw, gdy jest wicej 
                                     ?wykresw ni kolorw
        $text_color = ImageColorAllocate($image, $colors[$c][0], 
                                 $colors[$c][1], $colors[$c][2]);

        // rysowanie supkw i wartoci procentowych
        ImageFilledRectangle($image, $x, $y, $x + $bar,
                             $y + $bar_height, $text_color);
        ImageString($image, 3, $x + $bar + $padding, $y, "$percent%", $black);

         $y += 12;

         // wywietlanie odpowiedzi
         $wrapped = explode("\n", wordwrap($answers['answer'][$i], $line_width));
         foreach ($wrapped as $line) {
             ImageString($image, 2, $x, $y, $line, $black);
             $y += 12;
         }

         $y += 7;
     }

     // przycinanie obrazu przez kopiowanie
     $chart = ImageCreate(150, $y);
     ImageCopy($chart, $image, 0, 0, 0, 0, 150, $y);

     // dostarczenie obrazu
     header ('Content-type: image/png');
     ImagePNG($chart);

     // zwalnianie pamici
     ImageDestroy($image);
     ImageDestroy($chart);
}
